::------------------------------------------
::          script by BME/ILMHB 2012
::------------------------------------------
@ECHO OFF
CLS

::------------------------------------------
SET project=WACKISLE

::------------------------------------------
IF NOT EXIST BARF.exe GOTO nobarf
IF NOT EXIST %project% GOTO nofolder
IF EXIST !BACKUP GOTO yesfolder
MKDIR !BACKUP

IF NOT EXIST TILES018.art GOTO noart
COPY TILES018.art !BACKUP

:noart
COPY SOUNDS.rff !BACKUP
CD %project%
  COPY WACKISLE.map ..
  COPY TILES018.art ..
  COPY WACKISLE.ini ..
  COPY *.raw ..
  COPY SND.rfs ..
  CD ..

BARF SOUNDS.rff @SND.rfs
::------------------------------------------
BLOOD -ini WACKISLE.ini
::------------------------------------------
CLS

DEL *.raw
DEL WACKISLE.map
DEL WACKISLE.ini
DEL SND.rfs
CD !BACKUP
  COPY *.* ..
  DEL *.*
  CD ..
RD !BACKUP

GOTO done

::-----------------<MESSAGES>-----------------
:nobarf
ECHO ERROR - BARF.EXE needs to be in the main Blood folder!
GOTO abort

:nofolder
ECHO ERROR - Folder  %project%  does not exist!
GOTO abort

:yesfolder
ECHO ERROR - Folder  !BACKUP  already exist!
GOTO abort

:abort
ECHO Installation aborted.
GOTO end

:done
CLS
ECHO Installer by BME/ILMHB 2012
ECHO.
ECHO ALL FILES RESTORED!
GOTO end
::------------------------------------

:end
ECHO.