@ECHO OFF
CLS
::--------------
:: Put blood params (for example INI of user addon or map).
:: You will availabe to select this variant from play menu.
:: Since version 2.0, Weapon Mod should be compatible to EVERY addon/map ever created for Blood
SET params=
:: Example: -ini bpf.ini
::--------------

::--------------
:: Type batch file name to run (for example, batch file of user addon or map).
:: You will availabe to select this variant from play menu.
:: Since version 2.0, Weapon Mod should be compatible to EVERY addon/map ever created for Blood
SET bat_file=none
:: Example: CWHHROT.BAT
::--------------

::--------------
:: Set bmouse to 1 if you going to play with BMOUSE.
:: Note: you still must setup bmouse manually anyway.
SET bmouse=0
::--------------

::--------------
:: Set repair to 1 if you want to try repair WM required files. This option might
:: be useful if you close incorrectly weapon mod. For example, when you close
:: DosBox window instead of quitting using keys.
SET repair=1
:: Note that required files will be overwritten when restored (if possible).
::--------------

::--------------
:: Set 1 to skip play screen with game selection and get right in game after 
:: pressing "Install & Play" button.
:: Set 2 to skip play screen with game selection and get right to running
:: selected BAT file wich should be set in bat_file variable above
SET skip_play_screen=0
::--------------

::--------------
:: Specify RFF resource archive where to add weapons. By default is BLOOD.RFF
:: Usually, all Blood addons uses BLOOD.RFF, but some may not.
SET BLOOD_RFF=BLOOD.RFF
:: Note that BLOOD_RFF and SOUNDS_RFF can contain same name. This means addon uses single RFF
::--------------

::--------------
:: Specify RFF resource archive where to add weapons sounds. By default is SOUNDS.RFF
:: Usually, all Blood addons uses SOUNDS.RFF, but some may not.
SET SOUNDS_RFF=SOUNDS.RFF
:: Note that BLOOD_RFF and SOUNDS_RFF can contain same name. This means addon uses single RFF
::--------------

::--------------
:: Checks if Weapon Mod was run again (for example, from command line). If so - terminate 2-nd execution.
IF %incmd% == 1 goto wm_launched
::--------------

ECHO PREPARING WEAPON MOD FILES...

::--------------
:: Path to directory with weapons
SET wmpath=WPNMOD20
:: Currently must be set to "WPNMOD20" for Weapon Mod version 2.0. Do not change it.
::--------------

::--------------
:: This code tries to repair RFF and TILES023.ART files if DosBox was just closed
:: instead of when user quitting using key buttons.
:repair
IF NOT %repair% == 1 goto preparation_continues
IF EXIST TILES023.WM goto repair_t23
IF EXIST %wmpath%\BLOOD.RST goto repair_blood_rff
IF %BLOOD_RFF% == %SOUND_RFF% goto preparation_continues
IF EXIST %wmpath%\SOUNDS.RST goto repair_sounds_rff
goto preparation_continues

:repair_t23
IF EXIST TILES023.ART DEL TILES023.ART
REN TILES023.WM TILES023.ART
IF EXIST %wmpath%\T23.RN DEL %wmpath%\T23.RN
goto repair

:repair_blood_rff
DEL %BLOOD_RFF%
COPY %wmpath%\BLOOD.RST %BLOOD_RFF%
DEL %wmpath%\BLOOD.RST
goto repair

:repair_sounds_rff
DEL %SOUNDS_RFF%
COPY %wmpath%\SOUNDS.RST %SOUNDS_RFF%
DEL %wmpath%\SOUNDS.RST
goto repair
::--------------

:preparation_continues
::--------------
:: This one checks if Weapon Mod in Blood directory and if Blood is installed correctly.
IF NOT EXIST BLOOD.EXE goto no_blood
IF NOT EXIST %BLOOD_RFF% goto no_blood_rffs
IF NOT EXIST %SOUNDS_RFF% goto no_blood_rffs
::--------------

::--------------
:: If bmouse variable above was set to 1, then we check for existing.
:: If BMOUSE.EXE is not founded, then BMOUSE support will disabled (variable will set back to 0).
IF NOT %bmouse% == 1 goto preparation_continues_after_bmouse

:bmouse_check
IF EXIST BMOUSE.EXE goto preparation_continues_after_bmouse
CLS
ECHO  BMOUSE.EXE HAS NOT FOUNDED!
ECHO  CONTINUE ANYWAY? (Y/N)
CHOICE /C:yn /N ""
IF ERRORLEVEL 2 goto cls_end
IF ERRORLEVEL 1 SET bmouse=0
::--------------

:preparation_continues_after_bmouse
::--------------
:: If only you dont have BARF wich required of course for installing weapons.
IF NOT EXIST BARF.EXE COPY %wmpath%\3RD\BARF.EXE
::--------------

::--------------
:: Check if you going to use different RFFs, then launch Blood with them.
IF NOT %BLOOD_RFF% == BLOOD.RFF SET rff_param= -rff %BLOOD_RFF%
IF NOT %SOUNDS_RFF% == SOUNDS.RFF SET snd_param= -snd %SOUNDS_RFF%
::--------------

::--------------
:: Does nothing special. Provided for compatibility to avoid "Missing argument" error.
IF %BLOOD_RFF% == BLOOD.RFF SET rff_param= -rff BLOOD.RFF
IF %SOUNDS_RFF% == SOUNDS.RFF SET snd_param= -snd SOUNDS.RFF
::--------------

SET ns=NO
SET sl=YES

::--------------
:: Copies blank ART if no ART files founded. Required to load weapon's sprites 
:: as now they placed in TILES023 to avoid "4095" QAVEDIT limit.
IF NOT EXIST TILES016.ART COPY %wmpath%\BLANK.ART TILES016.ART
IF NOT EXIST TILES017.ART COPY %wmpath%\BLANK.ART TILES017.ART
IF NOT EXIST TILES018.ART COPY %wmpath%\BLANK.ART TILES018.ART
IF NOT EXIST TILES019.ART COPY %wmpath%\BLANK.ART TILES019.ART
IF NOT EXIST TILES020.ART COPY %wmpath%\BLANK.ART TILES020.ART
IF NOT EXIST TILES021.ART COPY %wmpath%\BLANK.ART TILES021.ART
IF NOT EXIST TILES022.ART COPY %wmpath%\BLANK.ART TILES022.ART
::--------------

::--------------
:: Detects if TILES023.ART NOT from Weapon Mod already exists. If so, then rename it 
:: RN extension until session is finished and then rename back. If TILES023.ART from 
:: Weapon mod - will copy once
IF NOT EXIST TILES023.ART goto t23_wm
IF EXIST %wmpath%\T23.CPY goto screen
IF EXIST TILES023.ART goto t23_other

:t23_wm
COPY %wmpath%\TILES023.ART
ECHO.>%wmpath%\T23.CPY
goto screen

:t23_other
REN TILES023.ART TILES023.WM
COPY %wmpath%\TILES023.ART
ECHO.>%wmpath%\T23.RN
goto screen
::--------------


:screen
CLS
ECHO.
ECHO.
ECHO.
ECHO                               WEAPONS MOD V2.0 by NoOne
ECHO               --------------------------------------------------------
ECHO               WEAPON                                          SELECTED
ECHO.
IF NOT EXIST %wmpath%\CLAW.flg SET claw=%ns%
IF EXIST %wmpath%\CLAW.flg     SET claw=%sl%
ECHO              [Q]  Beast Claws (Blood Alpha)  %claw%

IF NOT EXIST %wmpath%\SFORK.flg SET sfork=%ns%
IF EXIST %wmpath%\SFORK.flg    SET sfork=%sl%
ECHO              [W]  Silver pitchforks (More hits)  %sfork%

IF NOT EXIST %wmpath%\SHOT.flg SET shot=%ns%
IF EXIST %wmpath%\SHOT.flg     SET shot=%sl%
ECHO              [E]  Sawed-Off (Blood Alpha)  %shot%

IF NOT EXIST %wmpath%\HOLYD.flg SET holyd=%ns%
IF EXIST %wmpath%\HOLYD.flg     SET holyd=%sl%
ECHO              [R] "Holy Death" (New sawed-off, always akimbo)  %holyd%

IF NOT EXIST %wmpath%\HSAWED.flg SET hsaw=%ns%
IF EXIST %wmpath%\HSAWED.flg     SET hsaw=%sl%
ECHO              [T]  Retail sawed-off (New animation)  %hsaw%

IF NOT EXIST %wmpath%\RIOT.flg SET riot=%ns%
IF EXIST %wmpath%\RIOT.flg     SET riot=%sl%
ECHO              [Y]  Riot Shotgun (Shadow Warrior)  %riot%

IF NOT EXIST %wmpath%\NAPA.flg SET napa=%ns%
IF EXIST %wmpath%\NAPA.flg     SET napa=%sl%
ECHO               [U]  Napalm Launcher (Blood Alpha)  %napa%

IF NOT EXIST %wmpath%\AERO.flg SET aero=%ns%
IF EXIST %wmpath%\AERO.flg     SET aero=%sl%
ECHO               [I]  Aerosol Can (Blood Alpha)  %aero%

IF NOT EXIST %wmpath%\DYNA.flg SET dyna=%ns%
IF EXIST %wmpath%\DYNA.flg     SET dyna=%sl%
ECHO               [O]  Dynamite Bundles (Blood Alpha)  %dyna%

IF NOT EXIST %wmpath%\REVO.flg SET revo=%ns%
IF EXIST %wmpath%\REVO.flg     SET revo=%sl%
ECHO               [P]  Revolver (Power Slave)  %revo%

IF NOT EXIST %wmpath%\LEECH.flg SET leech=%ns%
IF EXIST %wmpath%\LEECH.flg     SET leech=%sl%
ECHO              [A]  Life Leech (Type 1)  %leech%

IF NOT EXIST %wmpath%\LEECH2.flg SET leech2=%ns%
IF EXIST %wmpath%\LEECH2.flg     SET leech2=%sl%
ECHO              [S]  Life Leech (Type 2)  %leech2%
ECHO.
ECHO               [1]  Install & Play                            [0]  Exit
ECHO               --------------------------------------------------------
ECHO.
ECHO                    Installer based on BME/ILMHB script [sep 2016]
ECHO.
CHOICE /C:qwertyuiopas10 /N ""
IF ERRORLEVEL 14 GOTO done
IF ERRORLEVEL 13 GOTO inst
IF ERRORLEVEL 12 GOTO leech2
IF ERRORLEVEL 11 GOTO leech
IF ERRORLEVEL 10 GOTO revo
IF ERRORLEVEL 9 GOTO dyna
IF ERRORLEVEL 8 GOTO aero
IF ERRORLEVEL 7 GOTO napa
IF ERRORLEVEL 6 GOTO riot
IF ERRORLEVEL 5 GOTO hsaw
IF ERRORLEVEL 4 GOTO holyd
IF ERRORLEVEL 3 GOTO shot
IF ERRORLEVEL 2 GOTO sfork
IF ERRORLEVEL 1 GOTO claw

:claw
IF NOT EXIST %wmpath%\CLAW.flg GOTO setclaw
IF EXIST %wmpath%\CLAW.flg GOTO unclaw
:setclaw
ECHO.>%wmpath%\CLAW.flg
DEL %wmpath%\SFORK.flg
GOTO clawxit
:unclaw
DEL %wmpath%\CLAW.flg
:clawxit
GOTO screen

:sfork
IF NOT EXIST %wmpath%\SFORK.flg GOTO setsfork
IF EXIST %wmpath%\SFORK.flg GOTO unsfork
:setsfork
ECHO.>%wmpath%\SFORK.flg
DEL %wmpath%\CLAW.flg
GOTO sforkxit
:unsfork
DEL %wmpath%\SFORK.flg
:sforkxit
GOTO screen

:shot
IF NOT EXIST %wmpath%\SHOT.flg GOTO setshot
IF EXIST %wmpath%\SHOT.flg GOTO unshot
:setshot
ECHO.>%wmpath%\SHOT.flg
DEL %wmpath%\RIOT.flg
DEL %wmpath%\HSAWED.flg
DEL %wmpath%\HOLYD.flg
GOTO shotxit
:unshot
DEL %wmpath%\SHOT.flg
:shotxit
GOTO screen

:holyd
IF NOT EXIST %wmpath%\HOLYD.flg GOTO setholyd
IF EXIST %wmpath%\HOLYD.flg GOTO unholyd
:setholyd
ECHO.>%wmpath%\HOLYD.flg
DEL %wmpath%\RIOT.flg
DEL %wmpath%\HSAWED.flg
DEL %wmpath%\SHOT.flg
GOTO holydxit
:unholyd
DEL %wmpath%\HOLYD.flg
:holydxit
GOTO screen

:hsaw
IF NOT EXIST %wmpath%\HSAWED.flg GOTO sethsaw
IF EXIST %wmpath%\HSAWED.flg GOTO unhsaw
:sethsaw
ECHO.>%wmpath%\HSAWED.flg
DEL %wmpath%\RIOT.flg
DEL %wmpath%\SHOT.flg
DEL %wmpath%\HOLYD.flg
GOTO hsawxit
:unhsaw
DEL %wmpath%\HSAWED.flg
:hsawxit
GOTO screen

:riot
IF NOT EXIST %wmpath%\RIOT.flg GOTO setriot
IF EXIST %wmpath%\RIOT.flg GOTO unriot
:setriot
ECHO.>%wmpath%\RIOT.flg
DEL %wmpath%\SHOT.flg
DEL %wmpath%\HSAWED.flg
DEL %wmpath%\HOLYD.flg
GOTO riotxit
:unriot
DEL %wmpath%\RIOT.flg
:riotxit
GOTO screen


:napa
IF NOT EXIST %wmpath%\NAPA.flg GOTO setnapa
IF EXIST %wmpath%\NAPA.flg GOTO unnapa
:setnapa
ECHO.>%wmpath%\NAPA.flg
GOTO napaxit
:unnapa
DEL %wmpath%\NAPA.flg
:napaxit
GOTO screen


:aero
IF NOT EXIST %wmpath%\AERO.flg GOTO setaero
IF EXIST %wmpath%\AERO.flg GOTO unaero
:setaero
ECHO.>%wmpath%\AERO.flg
GOTO aeroxit
:unaero
DEL %wmpath%\AERO.flg
:aeroxit
GOTO screen


:dyna
IF NOT EXIST %wmpath%\DYNA.flg GOTO setdyna
IF EXIST %wmpath%\DYNA.flg GOTO undyna
:setdyna
ECHO.>%wmpath%\DYNA.flg
GOTO dynaxit
:undyna
DEL %wmpath%\DYNA.flg
:dynaxit
GOTO screen


:revo
IF NOT EXIST %wmpath%\REVO.flg GOTO setrevo
IF EXIST %wmpath%\REVO.flg GOTO unrevo
:setrevo
ECHO.>%wmpath%\REVO.flg
GOTO revoxit
:unrevo
DEL %wmpath%\REVO.flg
:revoxit
GOTO screen


:leech
IF NOT EXIST %wmpath%\LEECH.flg GOTO setleech
IF EXIST %wmpath%\LEECH.flg GOTO unleech
:setleech
ECHO.>%wmpath%\LEECH.flg
DEL %wmpath%\LEECH2.flg
GOTO leechxit
:unleech
DEL %wmpath%\LEECH.flg
:leechxit
GOTO screen

:leech2
IF NOT EXIST %wmpath%\LEECH2.flg GOTO setleech2
IF EXIST %wmpath%\LEECH2.flg GOTO unleech2
:setleech2
ECHO.>%wmpath%\LEECH2.flg
DEL %wmpath%\LEECH.flg
GOTO leechxit2
:unleech2
DEL %wmpath%\LEECH2.flg
:leechxit2
GOTO screen
::========================

:inst
CLS
COPY %BLOOD_RFF% %wmpath%\BLOOD.RST
IF %BLOOD_RFF% == %SOUNDS_RFF% goto skip_snd
COPY %SOUNDS_RFF% %wmpath%\SOUNDS.RST

:skip_snd
IF EXIST %wmpath%\CLAW.flg CALL %wmpath%\CLAWINST
IF EXIST %wmpath%\SFORK.flg CALL %wmpath%\SFRKINST
IF EXIST %wmpath%\SHOT.flg CALL %wmpath%\SHOTINST
IF EXIST %wmpath%\HOLYD.flg CALL %wmpath%\HODINST
IF EXIST %wmpath%\HSAWED.flg CALL %wmpath%\HSWINST
IF EXIST %wmpath%\RIOT.flg CALL %wmpath%\RIOTINST
IF EXIST %wmpath%\NAPA.flg CALL %wmpath%\NAPAINST
IF EXIST %wmpath%\AERO.flg CALL %wmpath%\AEROINST
IF EXIST %wmpath%\DYNA.flg CALL %wmpath%\DYNAINST
IF EXIST %wmpath%\REVO.flg CALL %wmpath%\REVOINST
IF EXIST %wmpath%\LEECH.flg CALL %wmpath%\LEEINST
IF EXIST %wmpath%\LEECH2.flg CALL %wmpath%\LEE2INST

:play
CLS
IF %skip_play_screen% == 1 goto play_user
IF %skip_play_screen% == 2 goto play_bat_file
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO                               WEAPONS MOD V2.0 by NoOne
ECHO               --------------------------------------------------------
IF NOT %BLOOD_RFF% == BLOOD.RFF goto reminder
IF NOT %SOUNDS_RFF% == SOUNDS.RFF goto reminder
IF %BLOOD_RFF% == BLOOD.RFF goto skip_reminder
IF %SOUNDS_RFF% == SOUNDS.RFF goto skip_reminder
:reminder
ECHO               REMINDER: DIFFERENT RFF ARCHIVE(S) IS CURRENTLY SET!
ECHO               RFF: %BLOOD_RFF%        SND: %SOUNDS_RFF%
:skip_reminder
ECHO.
ECHO               [1] BLOOD
ECHO               [2] CRYPTIC PASSAGE
ECHO               [3] USER DEFINED MAP OR ADDON 
ECHO.                 %params%
IF NOT EXIST %bat_file% goto bat_file_skip
IF EXIST %bat_file% goto bat_file
:bat_file
ECHO               [B] BATCH FILE (%bat_file%)
ECHO.
:bat_file_skip
ECHO.
ECHO               [Q] RETURN BACK        [W] COMMAND LINE         [E] EXIT
ECHO.
ECHO               --------------------------------------------------------
ECHO                                 SELECT GAME TO PLAY
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
CHOICE /C:123qweb /N ""
IF ERRORLEVEL 7 GOTO play_bat_file
IF ERRORLEVEL 6 GOTO exit_clean
IF ERRORLEVEL 5 GOTO command_line
IF ERRORLEVEL 4 GOTO return_back_clean
IF ERRORLEVEL 3 GOTO play_user
IF ERRORLEVEL 2 GOTO play_crypt
IF ERRORLEVEL 1 GOTO play_blood

:play_blood
::-----------
CLS
IF %bmouse% == 1 goto play_blood_bmouse
BLOOD %rff_param% %snd_param%
goto play
::-----------

::-----------
:play_blood_bmouse
CLS
BMOUSE.EXE LAUNCH BLOOD.EXE %rff_param% %snd_param%
goto play
::-----------

:play_crypt
::-----------
CLS
IF %bmouse% == 1 goto play_crypt_bmouse
CRYPTIC %rff_param% %snd_param%
goto play
::-----------

:play_crypt_bmouse
::-----------
CLS
BMOUSE.EXE LAUNCH CRYPTIC.EXE %rff_param% %snd_param%
goto play
::-----------

:play_user
::-----------
CLS
IF %bmouse% == 1 goto play_user_bmouse
BLOOD %params% %rff_param% %snd_param%
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play
::-----------

:play_user_bmouse
::-----------
CLS
BMOUSE.EXE LAUNCH BLOOD.EXE %params% %rff_param% %snd_param%
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play
::-----------

:play_bat_file
::-----------
CLS
IF NOT EXIST %bat_file% goto no_bat_file
SET incmd=1
CALL %bat_file%
SET incmd=0
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play

:no_bat_file
ECHO NO BATCH FILE "%bat_file%" FOUNDED.
pause
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play
::-----------


:command_line
::-----------
CLS
SET incmd=1
COMMAND
SET incmd=0
goto play
::-----------

:return_back_clean
DEL %BLOOD_RFF%
REN %wmpath%\BLOOD.RST ../%BLOOD_RFF%
IF %BLOOD_RFF% == %SOUNDS_RFF% goto screen
DEL %SOUNDS_RFF%
REN %wmpath%\SOUNDS.RST ../%SOUNDS_RFF%
goto screen

:exit_clean
DEL %BLOOD_RFF%
REN %wmpath%\BLOOD.RST ../%BLOOD_RFF%
IF %BLOOD_RFF% == %SOUNDS_RFF% goto done
DEL %SOUNDS_RFF%
REN %wmpath%\SOUNDS.RST ../%SOUNDS_RFF%
goto done

:t23clean
DEL %wmpath%\T23.RN
DEL TILES023.ART
REN TILES023.WM TILES023.ART

:done
IF EXIST %wmpath%\T23.RN goto t23clean
CLS
ECHO.
ECHO  --------------------------------------- 
ECHO   Thanks for playing, visite our sites:
ECHO.
ECHO   http://cruo.bloodgame.ru
ECHO   http://baitd.bloodgame.ru/bme.htm
ECHO  ---------------------------------------
ECHO   Installer based on BME/ILMHB script
ECHO   sep 2016
ECHO.
goto end

:no_blood_rffs
CLS
ECHO.
IF NOT %BLOOD_RFF% == %SOUNDS_RFF% goto two_rff
IF %BLOOD_RFF% == %SOUNDS_RFF% goto single_rff

:two_rff
ECHO   SEEMS THERE ARE NO %BLOOD_RFF% AND/OR %SOUNDS_RFF%
ECHO   THOSE FILES ARE REQUIRED TO PLAY BLOOD.
ECHO   INSTALL %BLOOD_RFF% AND/OR %SOUNDS_RFF% TO BLOOD'S DIRECTORY.
goto end

:single_rff
ECHO   SEEMS THERE ARE NO %BLOOD_RFF%
ECHO   THIS FILE ARE REQUIRED TO PLAY BLOOD.
ECHO   INSTALL %BLOOD_RFF% TO BLOOD'S DIRECTORY. 
ECHO.
goto end

:no_blood_exe
CLS
ECHO.
ECHO   NO BLOOD FOUNDED IN CURRENT DIRECTORY!
ECHO   WEAPON MOD MUST BE PLACED IN BLOOD' ROOT DIRECTORY. 
ECHO.
goto end

:wm_launched
CLS
ECHO   WEAPON MOD IS ALREADY LAUNCHED.
goto cmd_end

:cls_end
CLS

:end
SET wmpath=
SET bmouse=
SET params=
SET ns=
SET sl=
SET claw=
SET sfork=
SET shot=
SET holyd=
SET hsaw=
SET riot=
SET napa=
SET aero=
SET dyna=
SET revo=
SET leech=
SET leech2=
SET repair=
SET BLOOD_RFF=
SET SOUNDS_RFF=
SET rff_param=
SET snd_param=
SET skip_play_screen=
SET bat_file=

:cmd_end