::------------------------------------------
::          script by BME/ILMHB 2012
::------------------------------------------
@ECHO OFF
CLS

::------------------------------------------
SET project=BAITD2

::------------------------------------------
IF NOT EXIST BARF.exe GOTO nobarf
IF NOT EXIST %project% GOTO nofolder
IF EXIST !BACKUP GOTO yesfolder
MKDIR !BACKUP

COPY *.dat !BACKUP
COPY TILES009.art !BACKUP

IF NOT EXIST TILES015.art GOTO t16
COPY TILES015.art !BACKUP
:t16
IF NOT EXIST TILES016.art GOTO t17
COPY TILES016.art !BACKUP
:t17
IF NOT EXIST TILES017.art GOTO t18
COPY TILES017.art !BACKUP
:t18
IF NOT EXIST TILES018.art GOTO t19
COPY TILES018.art !BACKUP
:t19
IF NOT EXIST TILES019.art GOTO t20
COPY TILES019.art !BACKUP
:t20


CD %project%
  COPY BAITD2.ini ..
  COPY BAITD2.map ..
  COPY *.rfs ..
  COPY *.art ..
  COPY *.dat ..
  CD ..

BARF SOUNDS.rff @SND.rfs
BARF BLOOD.rff @KVX.rfs

::------------------------------------------
BLOOD -ini %project%.ini

::------------------------------------------
CLS
DEL TILES015.art
DEL TILES016.art
DEL TILES017.art
DEL TILES018.art
DEL TILES019.art
DEL TILES020.art
DEL %project%.ini
DEL %project%.map
DEL *.rfs

CD !BACKUP
  COPY *.* ..
  DEL *.*
  CD ..
RD !BACKUP

GOTO done

::-----------------<MESSAGES>-----------------
:nobarf
ECHO ERROR - BARF.EXE needs to be in the main Blood folder!
GOTO abort

:nofolder
ECHO ERROR - Folder  %project%  does not exist!
GOTO abort

:yesfolder
ECHO ERROR - Folder  !BACKUP  already exist!
GOTO abort

:abort
ECHO Installation aborted.
GOTO end

:done
CLS
ECHO Installer by BME/ILMHB 2012
ECHO.
ECHO ALL FILES RESTORED!
GOTO end
::------------------------------------

:end
ECHO.