::+============================================================================+::
::+ Welcome to the Weapons Mod main file!                                      +::
::+ Scroll below to line 60 if you want set your own params.                   +::
::+ Starting from that line you can set params, external file and many other   +::
::+ options to play your favorite addons with new weapons from this mod.       +::
::+ All possible parameters is commented so you wont (i hope) messed up.       +::
::+============================================================================+::

@ECHO OFF
CLS

::--------------
:: Checks if Weapon Mod was run again (for example, from command promt). If so - terminate 2-nd execution.
IF NOT %incmd% == 1 SET incmd=0
IF %incmd% == 1 goto wm_launched
::--------------

CLS

::--------------
:: Weapon Mod is designed to work preferable under DosBox, so we check if WM ran
:: in DosBox environment. If no - exit the program.
:dosbox_check
IF NOT EXIST Z:\COMMAND.COM goto nodosbox
IF NOT EXIST Z:\RESCAN.COM goto nodosbox
goto loading

:nodosbox
CLS
ECHO.
ECHO WEAPON MOD IS DESIGNED TO WORK UNDER DOSBOX.
ECHO CORRECT WORK ON OTHER EMULATORS AND/OR OPERATING SYSTEMS IS NOT GUARANTED.
ECHO QUITTING NOW.
goto end
::--------------

:loading
ECHO.
ECHO  LOADING WEAPONS MOD #3 FOR DOSBOX...
ECHO.
ECHO  IF YOU FEEL LOADING PROCESS IS HANG, PLEASE TRY LAUNCH
ECHO  WEAPONS MOD IN CLEAR DOSBOX COMMAND PROMT.
ECHO.
ECHO  SHELL EXTENSIONS LIKE NORTON COMMANDER IS NOT
ECHO  SUPPORTED. PLAIN DOS IS ALSO NOT RECOMMENDED.

::--------------
:: Checking environment space.
SET envtest=teeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeest
IF %envtest% == teeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeest goto loading_continue
goto no_env_space
::--------------

:loading_continue
SET envtest=
::--------------
:: Put blood params (for example INI of user addon or map).
:: You will availabe to select this variant from play menu.
:: Since version 2.0, Weapon Mod should be compatible to EVERY addon/map ever created for Blood
SET params=none
:: Example: -ini bpf.ini
::--------------

::--------------
:: Type external file name to run (for example, batch file of user addon or map).
:: You will availabe to select this variant from play menu.
:: Since version 2.0, Weapon Mod should be compatible to EVERY addon/map ever created for Blood
SET bat_file=none
:: Example: CWHHROT.BAT OR RATM.COM
::--------------

::--------------
:: Set to 1 if you going to play with BMOUSE.
:: Note: you still must setup bmouse manually anyway.
SET bmouse=0
::--------------

::--------------
:: Set repair to 1 if you want to try repair WM required files. This option might
:: be useful if you close incorrectly weapon mod. For example, when you close
:: DosBox window instead of quitting using keys.
SET repair=1
:: Note that required files will be overwritten when restored (if possible).
::--------------

::--------------
:: Set pernament_install to 1 if you want install weapons pernamently e.g 
:: without resetting them back after exiting. This option might be useful
:: if you dont want use WM inerface to play blood or it's addons.
SET pernament_install=0
:: Note that repairing files will be disabled.
::--------------

::--------------
:: Set 1 to skip play screen with game selection and get right in game after 
:: pressing "Install & Play" button.
:: Set 2 to skip play screen with game selection and get right to running
:: selected BAT file wich should be set in bat_file variable above.
:: Set 3 to skip play screen with game selection and get right to multiplayer
:: game screen.
SET skip_play_screen=0
::--------------

::--------------
:: Set 1 to skip main screen with weapons selection and get right to 
:: installing of selected weapons saved from previous session (if exists).
SET skip_main_screen=0
::--------------

::--------------
:: Specify RFF resource archive where to add weapons. By default is BLOOD.RFF
:: Usually, all Blood addons uses BLOOD.RFF, but some may not.
SET BLOOD_RFF=BLOOD.RFF
:: Note that BLOOD_RFF and SOUNDS_RFF can contain same name. This means addon uses single RFF
::--------------

::--------------
:: Specify RFF resource archive where to add weapons sounds. By default is SOUNDS.RFF
:: Usually, all Blood addons uses SOUNDS.RFF, but some may not.
SET SOUNDS_RFF=SOUNDS.RFF
:: Note that BLOOD_RFF and SOUNDS_RFF can contain same name. This means addon uses single RFF
::--------------

::--------------
:: Specify main EXE file that will be patched (required for some weapons). 
:: Default is BLOOD.EXE. Usually, all Blood addons uses BLOOD.EXE to run, but some may not.
SET BLOOD_EXE=BLOOD.EXE
:: Note this is experimental feature.
::--------------

::--------------
:: Path to directory with weapons
SET wmpath=WPNMOD30
:: Currently must be set to "WPNMOD30" for Weapon Mod version 3.0. Do not change it.
::--------------

::--------------
:: Sets TXT file that will be shown by default when enterring in GetInfo screen.
SET info=INFO.TXT
::--------------

ECHO ----------------------------------------------------->%wmpath%\WMLOG.LOG
ECHO WM LOG FILE>>%wmpath%\WMLOG.LOG
ECHO ----------------------------------------------------->>%wmpath%\WMLOG.LOG
ECHO.>>%wmpath%\WMLOG.LOG

::--------------
:: Check if "pernament_istall" is enabled.
IF %pernament_install% == 1 ECHO !!!!!! PERNAMENT INSTALL IS ENABLED>>%wmpath%\WMLOG.LOG
::--------------

::--------------
:: Check if TEMP directory exist in WM path.
IF NOT EXIST %wmpath%\TEMP MD %wmpath%\TEMP
::--------------

CLS
IF %1 == q SET skip_main_screen=1
IF %2 == q SET skip_play_screen=1
IF %2 == s SET skip_play_screen=1
IF %1 == s SET skip_play_screen=1
IF %2 == b SET skip_play_screen=2
IF %1 == b SET skip_play_screen=2
IF %2 == m SET skip_play_screen=3
IF %1 == b SET skip_play_screen=3


::--------------
:: This code tries to repair core files if DosBox was just closed
:: instead of when user quitting using key buttons.
:repair
CLS
IF %pernament_install% == 1 goto preparation_continues
IF NOT %repair% == 1 goto preparation_continues
IF EXIST %wmpath%\TEMP\TILES023.ART goto repair_t23
IF EXIST %wmpath%\TEMP\%BLOOD_EXE% goto repair_blood_exe
IF EXIST %wmpath%\TEMP\%BLOOD_RFF% goto repair_blood_rff
IF %BLOOD_RFF% == %SOUNDS_RFF% goto preparation_continues
IF EXIST %wmpath%\TEMP\%SOUNDS_RFF% goto repair_sounds_rff
goto preparation_continues


:repair_t23
ECHO CHECKING AND REPAIRING TILES023.ART AFTER INCORRECT EXIT FROM WM...>>%wmpath%\WMLOG.LOG
IF EXIST TILES023.ART DEL TILES023.ART>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\TILES023.ART>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\TILES023.ART>>%wmpath%\WMLOG.LOG
goto repair

:repair_blood_exe
ECHO CHECKING AND REPAIRING %BLOOD_EXE% AFTER INCORRECT EXIT FROM WM...>>%wmpath%\WMLOG.LOG
IF EXIST %BLOOD_EXE% DEL %BLOOD_EXE%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
goto repair

:repair_blood_rff
ECHO CHECKING AND REPAIRING %BLOOD_RFF% AFTER INCORRECT EXIT FROM WM...>>%wmpath%\WMLOG.LOG
IF EXIST %BLOOD_RFF% DEL %BLOOD_RFF%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
goto repair

:repair_sounds_rff
ECHO CHECKING AND REPAIRING %SOUNDS_RFF% AFTER INCORRECT EXIT FROM WM...>>%wmpath%\WMLOG.LOG
IF EXIST %SOUNDS_RFF% DEL %SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
goto repair
::--------------

:preparation_continues
::--------------
:: This one checks if Weapon Mod in Blood directory and if Blood is installed correctly.
IF NOT EXIST BLOOD.EXE goto no_blood_exe
IF NOT EXIST %BLOOD_RFF% goto no_blood_rffs
IF NOT EXIST %SOUNDS_RFF% goto no_blood_rffs
::--------------

::--------------
:: If bmouse variable above was set to 1, then we check for existing.
:: If BMOUSE.EXE is not founded, then BMOUSE support will disabled (variable will set back to 0).
IF NOT %bmouse% == 1 goto preparation_continues_after_bmouse

:bmouse_check
IF EXIST BMOUSE.EXE goto preparation_continues_after_bmouse
CLS
ECHO  BMOUSE.EXE HAS NOT FOUNDED!
ECHO  CONTINUE ANYWAY? (Y/N)
CHOICE /C:yn /N ""
IF ERRORLEVEL 2 goto cls_end
IF ERRORLEVEL 1 SET bmouse=0
::--------------

:preparation_continues_after_bmouse
::--------------
:: Check if you going to use different RFFs, then launch Blood with them.
IF NOT %BLOOD_RFF% == BLOOD.RFF SET rff_param= -rff %BLOOD_RFF%
IF NOT %SOUNDS_RFF% == SOUNDS.RFF SET snd_param= -snd %SOUNDS_RFF%
::--------------

::--------------
:: Does nothing special. Provided for compatibility to avoid "Missing argument" error.
IF %BLOOD_RFF% == BLOOD.RFF SET rff_param= -rff BLOOD.RFF
IF %SOUNDS_RFF% == SOUNDS.RFF SET snd_param= -snd SOUNDS.RFF
::--------------

::--------------
:: Copies blank ART if no ART files founded. Required to load weapon's sprites 
:: as now they placed in TILES023 to avoid "4095" QAVEDIT limit.
ECHO CHECKING TILES016-022 FOR EXITING...>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES016.ART COPY %wmpath%\BLANK.ART TILES016.ART>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES017.ART COPY %wmpath%\BLANK.ART TILES017.ART>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES018.ART COPY %wmpath%\BLANK.ART TILES018.ART>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES019.ART COPY %wmpath%\BLANK.ART TILES019.ART>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES020.ART COPY %wmpath%\BLANK.ART TILES020.ART>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES021.ART COPY %wmpath%\BLANK.ART TILES021.ART>>%wmpath%\WMLOG.LOG
IF NOT EXIST TILES022.ART COPY %wmpath%\BLANK.ART TILES022.ART>>%wmpath%\WMLOG.LOG
::--------------

::--------------
:: Detects if TILES023.ART NOT from Weapon Mod already exists. If so, then store it 
:: until session is finished and then rename back. If TILES023.ART from 
:: Weapon mod - will copy once
IF NOT EXIST TILES023.ART goto t23_wm
IF EXIST %wmpath%\T23.CPY goto pre_screen
IF EXIST TILES023.ART goto t23_other

:t23_wm
COPY %wmpath%\TILES023.ART
ECHO TILES023.ART HAS BEEN COPIED FROM WM DIR>%wmpath%\T23.CPY
goto pre_screen

:t23_other
IF %pernament_install% == 1 goto pre_screen
IF EXIST TILES023.ART REN TILES023.ART %wmpath%\TEMP\TILES023.ART
COPY %wmpath%\TILES023.ART
goto pre_screen
::--------------

:pre_screen
IF %skip_main_screen% == 1 goto inst
goto screen

:screen
CLS
SET sl= [5;32m[0;32m[0m 
ECHO.
ECHO           [0mͻ
ECHO         Ķ   [7;41m   [1;33mWEAPONS MOD #3  FOR BLOOD V1.10 - 1.21   [7;41m[0m   Ŀ
ECHO        

SET ns= [1;31m[0;34m[1;37m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\CLAW.flg SET claw=%ns%
IF EXIST %wmpath%\PRST\CURST\CLAW.flg     SET claw=%sl%
ECHO         [1;31m[1;33m[Q][0m  [0;36m Beast Claws[0m (Blood Alpha)  %claw%
SET claw=

SET ns= [1;31m[1;37m[1;37m[0;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\SFORK.flg SET sfork=%ns%
IF EXIST %wmpath%\PRST\CURST\SFORK.flg    SET sfork=%sl%
ECHO         [1;31m[1;33m[W][0m  [0;36m Silver pitchfork[0m  %sfork%
SET sfork=

SET ns= [1;31m[1;34m[1;37m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\AXE.flg SET axe=%ns%
IF EXIST %wmpath%\PRST\CURST\AXE.flg    SET axe=%sl%
ECHO         [1;31m[1;33m[E][0m  [0;36m Axe[0m  %axe%
SET axe=

SET ns= [1;31m[0;34m[1;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\HEART.flg SET heart=%ns%
IF EXIST %wmpath%\PRST\CURST\HEART.flg    SET heart=%sl%
ECHO         [0m[1;33m[R][0m  [0;36m Wrath Heart[0m (SW Beta and Retail mix, edited)  %heart%
SET heart=

SET ns= [1;31m[1;34m[0;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\PUMP.flg SET pump=%ns%
IF EXIST %wmpath%\PRST\CURST\PUMP.flg    SET pump=%sl%
ECHO         [1;31m[1;33m[T][0m  [0;36m Pump Action Shotgun[0m  %pump%
SET pump=

SET ns= [1;31m[1;34m[1;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\BRIOT.flg SET briot=%ns%
IF EXIST %wmpath%\PRST\CURST\BRIOT.flg    SET briot=%sl%
ECHO         [1;31m[1;33m[Y][0m  [0;36m Triple DZ[0m (SW Beta, edited)  %briot%
SET briot=

SET ns= [0;31m[1;37m[0;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\LUPR.flg SET lupr=%ns%
IF EXIST %wmpath%\PRST\CURST\LUPR.flg    SET lupr=%sl%
ECHO         [1;31m[1;33m[U][0m  [0;36m Lupara[0m (Single barreled sawn-off)  %lupr%
SET lupr=

SET ns= [1;37m[0;34m[1;37m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\SHOT.flg SET shot=%ns%
IF EXIST %wmpath%\PRST\CURST\SHOT.flg     SET shot=%sl%
ECHO         [1;31m[1;33m[I][0m  [0;36m Sawed-Off[0m (Blood Alpha)  %shot%
SET shot=

SET ns= [1;31m[1;34m[1;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\HOLYD.flg SET holyd=%ns%
IF EXIST %wmpath%\PRST\CURST\HOLYD.flg     SET holyd=%sl%
ECHO         [1;31m[1;33m[O][0m  [0;36m "Holy Death"[0m (New sawed-off, always akimbo)  %holyd%
SET holyd=

SET ns= [1;37m[1;37m[1;37m[0;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\HSAWED.flg SET hsaw=%ns%
IF EXIST %wmpath%\PRST\CURST\HSAWED.flg     SET hsaw=%sl%
ECHO         [1;31m[1;33m[P][0m  [0;36m Vanilla sawed-off[0m (Better animation)  %hsaw%
SET hsaw=

SET ns= [1;31m[0;34m[1;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\RIOT.flg SET riot=%ns%
IF EXIST %wmpath%\PRST\CURST\RIOT.flg     SET riot=%sl%
ECHO         [1;31m[1;33m[A][0m  [0;36m Riot Shotgun[0m (Shadow Warrior Retail)  %riot%
SET riot=

SET ns= [1;37m[0;34m[1;37m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\NAPA.flg SET napa=%ns%
IF EXIST %wmpath%\PRST\CURST\NAPA.flg     SET napa=%sl%
ECHO         [0m[1;33m[S][0m  [0;36m Napalm Launcher[0m (Blood Alpha)  %napa%
SET napa=

SET ns= [1;37m[1;37m[1;37m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\AERO.flg SET aero=%ns%
IF EXIST %wmpath%\PRST\CURST\AERO.flg     SET aero=%sl%
ECHO         [0m[1;33m[D][0m  [0;36m Aerosol Can[0m (Blood Alpha)  %aero%
SET aero=

SET ns= [1;37m[1;37m[1;37m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\DYNA.flg SET dyna=%ns%
IF EXIST %wmpath%\PRST\CURST\DYNA.flg     SET dyna=%sl%
ECHO         [0m[1;33m[F][0m  [0;36m Dynamite Bundles[0m (Blood Alpha)  %dyna%
SET dyna=

SET ns= [0;31m[0;34m[0;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\COLT.flg SET colt=%ns%
IF EXIST %wmpath%\PRST\CURST\COLT.flg     SET colt=%sl%
ECHO         [1;31m[1;33m[G][0m  [0;36m Colt MI12[0m  %colt%
SET colt=

SET ns= [0;31m[0;34m[0;36m[1;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\REVO.flg SET revo=%ns%
IF EXIST %wmpath%\PRST\CURST\REVO.flg     SET revo=%sl%
ECHO         [1;31m[1;33m[H][0m  [0;36m Revolver[0m (Power Slave / Exhumed)  %revo%
SET revo=

SET ns= [1;37m[1;34m[0;36m[0;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\COIL.flg SET coil=%ns%
IF EXIST %wmpath%\PRST\CURST\COIL.flg     SET coil=%sl%
ECHO         [0m[1;33m[J][0m  [0;36m Tesla coil[0m  %coil%
SET coil=

SET ns= [0;31m[1;34m[0;36m[0;35m[0m 
IF NOT EXIST %wmpath%\PRST\CURST\LEECH.flg SET leech=%ns%
IF EXIST %wmpath%\PRST\CURST\LEECH.flg     SET leech=%sl%
ECHO         [0m[1;33m[K][0m  [0;36m Life Leech[0m (Faster, better balance)  %leech%
SET coil=
ECHO        
ECHO         Ķ [0;31m[1][1;37m Install & Play[0m  [0;31m[2] [1;37mPresets[0m  [0;31m[3] [1;37mGetInfo[0m  [0;31m[0] [0mExit 
ECHO           ͼ
SET ns=
SET sl=
IF NOT EXIST %wmpath%\PRST\CURST\SEC.flg CHOICE /C:qwertyuiopasdfghjk1230' /N "                     [31m [1;37m   [0;31m?![0;1;37m    [0;31m[0m[2;61H"
IF     EXIST %wmpath%\PRST\CURST\SEC.flg CHOICE /C:qwertyuiopasdfghjk1230' /N "                     [31m [5;1;37mA SECRET IS REVEALED [0;31m[0m[2;61H"
IF ERRORLEVEL 23 GOTO sec     
IF ERRORLEVEL 22 GOTO done
IF ERRORLEVEL 21 GOTO screen_info
IF ERRORLEVEL 20 GOTO preset_select_action
IF ERRORLEVEL 19 GOTO inst
IF ERRORLEVEL 18 GOTO leech
IF ERRORLEVEL 17 GOTO coil
IF ERRORLEVEL 16 GOTO revo
IF ERRORLEVEL 15 GOTO colt
IF ERRORLEVEL 14 GOTO dyna
IF ERRORLEVEL 13 GOTO aero
IF ERRORLEVEL 12 GOTO napa
IF ERRORLEVEL 11 GOTO riot
IF ERRORLEVEL 10 GOTO hsaw
IF ERRORLEVEL 9 GOTO holyd
IF ERRORLEVEL 8 GOTO shot
IF ERRORLEVEL 7 GOTO lupr
IF ERRORLEVEL 6 GOTO briot
IF ERRORLEVEL 5 GOTO pump
IF ERRORLEVEL 4 GOTO heart
IF ERRORLEVEL 3 GOTO axe
IF ERRORLEVEL 2 GOTO sfork
IF ERRORLEVEL 1 GOTO claw

:sec
IF EXIST %wmpath%\PRST\CURST\CLAW.flg goto screen
IF NOT EXIST %wmpath%\PRST\CURST\SEC.flg GOTO setsec
IF EXIST %wmpath%\PRST\CURST\SEC.flg GOTO unsec
:setsec
ECHO.>%wmpath%\PRST\CURST\SEC.flg
DEL %wmpath%\PRST\CURST\CLAW.flg
GOTO screen
:unsec
DEL %wmpath%\PRST\CURST\SEC.flg
GOTO screen


:claw
IF NOT EXIST %wmpath%\PRST\CURST\CLAW.flg GOTO setclaw
IF EXIST %wmpath%\PRST\CURST\CLAW.flg GOTO unclaw
:setclaw
ECHO.>%wmpath%\PRST\CURST\CLAW.flg
DEL %wmpath%\PRST\CURST\SFORK.flg
DEL %wmpath%\PRST\CURST\SEC.flg
DEL %wmpath%\PRST\CURST\AXE.flg
GOTO screen
:unclaw
DEL %wmpath%\PRST\CURST\CLAW.flg
GOTO screen


:sfork
IF NOT EXIST %wmpath%\PRST\CURST\SFORK.flg GOTO setsfork
IF EXIST %wmpath%\PRST\CURST\SFORK.flg GOTO unsfork
:setsfork
ECHO.>%wmpath%\PRST\CURST\SFORK.flg
DEL %wmpath%\PRST\CURST\CLAW.flg
DEL %wmpath%\PRST\CURST\AXE.flg
GOTO screen
:unsfork
DEL %wmpath%\PRST\CURST\SFORK.flg
GOTO screen


:axe
IF NOT EXIST %wmpath%\PRST\CURST\AXE.flg GOTO setaxe
IF EXIST %wmpath%\PRST\CURST\AXE.flg GOTO unaxe
:setaxe
ECHO.>%wmpath%\PRST\CURST\AXE.flg
DEL %wmpath%\PRST\CURST\SFORK.flg
DEL %wmpath%\PRST\CURST\CLAW.flg
GOTO screen
:unaxe
DEL %wmpath%\PRST\CURST\AXE.flg
GOTO screen


:heart
IF NOT EXIST %wmpath%\PRST\CURST\HEART.flg GOTO setheart
IF EXIST %wmpath%\PRST\CURST\HEART.flg GOTO unheart
:setheart
ECHO.>%wmpath%\PRST\CURST\HEART.flg
GOTO screen
:unheart
DEL %wmpath%\PRST\CURST\HEART.flg
GOTO screen


:pump
IF NOT EXIST %wmpath%\PRST\CURST\PUMP.flg GOTO setpump
IF EXIST %wmpath%\PRST\CURST\PUMP.flg GOTO unpump
:setpump
ECHO.>%wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\SHOT.flg
DEL %wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen
:unpump
DEL %wmpath%\PRST\CURST\PUMP.flg
GOTO screen


:briot
IF NOT EXIST %wmpath%\PRST\CURST\BRIOT.flg GOTO setbriot
IF EXIST %wmpath%\PRST\CURST\BRIOT.flg GOTO unbriot
:setbriot
ECHO.>%wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\SHOT.flg
DEL %wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen
:unbriot
DEL %wmpath%\PRST\CURST\BRIOT.flg
GOTO screen


:lupr
IF NOT EXIST %wmpath%\PRST\CURST\LUPR.flg GOTO setlupr
IF EXIST %wmpath%\PRST\CURST\LUPR.flg GOTO unlupr
:setlupr
ECHO.>%wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\SHOT.flg
DEL %wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen
:unlupr
DEL %wmpath%\PRST\CURST\LUPR.flg
GOTO screen


:shot
IF NOT EXIST %wmpath%\PRST\CURST\SHOT.flg GOTO setshot
IF EXIST %wmpath%\PRST\CURST\SHOT.flg GOTO unshot
:setshot
ECHO.>%wmpath%\PRST\CURST\SHOT.flg
DEL %wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen
:unshot
DEL %wmpath%\PRST\CURST\SHOT.flg
GOTO screen


:holyd
IF NOT EXIST %wmpath%\PRST\CURST\HOLYD.flg GOTO setholyd
IF EXIST %wmpath%\PRST\CURST\HOLYD.flg GOTO unholyd
:setholyd
ECHO.>%wmpath%\PRST\CURST\HOLYD.flg
DEL %wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\SHOT.flg
GOTO screen
:unholyd
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen

:hsaw
IF NOT EXIST %wmpath%\PRST\CURST\HSAWED.flg GOTO sethsaw
IF EXIST %wmpath%\PRST\CURST\HSAWED.flg GOTO unhsaw
:sethsaw
ECHO.>%wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\SHOT.flg
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen
:unhsaw
DEL %wmpath%\PRST\CURST\HSAWED.flg
GOTO screen

:riot
IF NOT EXIST %wmpath%\PRST\CURST\RIOT.flg GOTO setriot
IF EXIST %wmpath%\PRST\CURST\RIOT.flg GOTO unriot
:setriot
ECHO.>%wmpath%\PRST\CURST\RIOT.flg
DEL %wmpath%\PRST\CURST\PUMP.flg
DEL %wmpath%\PRST\CURST\LUPR.flg
DEL %wmpath%\PRST\CURST\BRIOT.flg
DEL %wmpath%\PRST\CURST\SHOT.flg
DEL %wmpath%\PRST\CURST\HSAWED.flg
DEL %wmpath%\PRST\CURST\HOLYD.flg
GOTO screen
:unriot
DEL %wmpath%\PRST\CURST\RIOT.flg
GOTO screen


:napa
IF NOT EXIST %wmpath%\PRST\CURST\NAPA.flg GOTO setnapa
IF EXIST %wmpath%\PRST\CURST\NAPA.flg GOTO unnapa
:setnapa
ECHO.>%wmpath%\PRST\CURST\NAPA.flg
GOTO screen
:unnapa
DEL %wmpath%\PRST\CURST\NAPA.flg
GOTO screen


:aero
IF NOT EXIST %wmpath%\PRST\CURST\AERO.flg GOTO setaero
IF EXIST %wmpath%\PRST\CURST\AERO.flg GOTO unaero
:setaero
ECHO.>%wmpath%\PRST\CURST\AERO.flg
GOTO screen
:unaero
DEL %wmpath%\PRST\CURST\AERO.flg
GOTO screen


:dyna
IF NOT EXIST %wmpath%\PRST\CURST\DYNA.flg GOTO setdyna
IF EXIST %wmpath%\PRST\CURST\DYNA.flg GOTO undyna
:setdyna
ECHO.>%wmpath%\PRST\CURST\DYNA.flg
GOTO screen
:undyna
DEL %wmpath%\PRST\CURST\DYNA.flg
GOTO screen


:colt
IF NOT EXIST %wmpath%\PRST\CURST\COLT.flg GOTO setcolt
IF EXIST %wmpath%\PRST\CURST\COLT.flg GOTO uncolt
:setcolt
ECHO.>%wmpath%\PRST\CURST\COLT.flg
DEL %wmpath%\PRST\CURST\REVO.flg
GOTO screen
:uncolt
DEL %wmpath%\PRST\CURST\COLT.flg
GOTO screen


:revo
IF NOT EXIST %wmpath%\PRST\CURST\REVO.flg GOTO setrevo
IF EXIST %wmpath%\PRST\CURST\REVO.flg GOTO unrevo
:setrevo
ECHO.>%wmpath%\PRST\CURST\REVO.flg
DEL %wmpath%\PRST\CURST\COLT.flg
GOTO screen
:unrevo
DEL %wmpath%\PRST\CURST\REVO.flg
GOTO screen


:coil
IF NOT EXIST %wmpath%\PRST\CURST\COIL.flg GOTO setcoil
IF EXIST %wmpath%\PRST\CURST\COIL.flg GOTO uncoil
:setcoil
ECHO.>%wmpath%\PRST\CURST\COIL.flg
GOTO screen
:uncoil
DEL %wmpath%\PRST\CURST\COIL.flg
GOTO screen


:leech
IF NOT EXIST %wmpath%\PRST\CURST\LEECH.flg GOTO setleech
IF EXIST %wmpath%\PRST\CURST\LEECH.flg GOTO unleech
:setleech
ECHO.>%wmpath%\PRST\CURST\LEECH.flg
GOTO screen
:unleech
DEL %wmpath%\PRST\CURST\LEECH.flg
GOTO screen
::========================

:inst
CLS
IF %pernament_install% == 1 goto skip_snd
ECHO.>>%wmpath%\WMLOG.LOG
ECHO COPYING GAME CORE FILES BEFORE SESSION>>%wmpath%\WMLOG.LOG
ECHO.>>%wmpath%\WMLOG.LOG
COPY %BLOOD_EXE% %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
COPY %BLOOD_RFF% %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
IF %BLOOD_RFF% == %SOUNDS_RFF% goto skip_snd
COPY %SOUNDS_RFF% %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG

:skip_snd
IF EXIST %wmpath%\RESRFF.rfs DEL %wmpath%\RESRFF.rfs
IF EXIST %wmpath%\SNDRFF.rfs DEL %wmpath%\SNDRFF.rfs
IF EXIST %wmpath%\PRST\CURST\PUMP.flg CALL %wmpath%\PUMPINST
IF EXIST %wmpath%\PRST\CURST\SEC.flg CALL %wmpath%\SECINST
IF EXIST %wmpath%\PRST\CURST\CLAW.flg CALL %wmpath%\CLAWINST
IF EXIST %wmpath%\PRST\CURST\SFORK.flg CALL %wmpath%\SFRKINST
IF EXIST %wmpath%\PRST\CURST\AXE.flg CALL %wmpath%\AXEINST
IF EXIST %wmpath%\PRST\CURST\HEART.flg CALL %wmpath%\HEARINST
IF EXIST %wmpath%\PRST\CURST\BRIOT.flg CALL %wmpath%\TRIPINST
IF EXIST %wmpath%\PRST\CURST\LUPR.flg CALL %wmpath%\LUPRINST
IF EXIST %wmpath%\PRST\CURST\SHOT.flg CALL %wmpath%\SHOTINST
IF EXIST %wmpath%\PRST\CURST\HOLYD.flg CALL %wmpath%\HODINST
IF EXIST %wmpath%\PRST\CURST\HSAWED.flg CALL %wmpath%\HSWINST
IF EXIST %wmpath%\PRST\CURST\RIOT.flg CALL %wmpath%\RIOTINST
IF EXIST %wmpath%\PRST\CURST\NAPA.flg CALL %wmpath%\NAPAINST
IF EXIST %wmpath%\PRST\CURST\AERO.flg CALL %wmpath%\AEROINST
IF EXIST %wmpath%\PRST\CURST\DYNA.flg CALL %wmpath%\DYNAINST
IF EXIST %wmpath%\PRST\CURST\COLT.flg CALL %wmpath%\COLTINST
IF EXIST %wmpath%\PRST\CURST\REVO.flg CALL %wmpath%\REVOINST
IF EXIST %wmpath%\PRST\CURST\COIL.flg CALL %wmpath%\COILINST
IF EXIST %wmpath%\PRST\CURST\LEECH.flg CALL %wmpath%\LEEINST
IF NOT EXIST %wmpath%\RESRFF.rfs goto play
TYPE %wmpath%\SEMI.SYM>>%wmpath%\RESRFF.rfs
CLS
ECHO.
ECHO.
ECHO.
ECHO             [5;1;36mĿ[0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                Ŀ              [0m
ECHO             [5;1;36m             ĳ [5;1;37mINSTALLING WEAPONS[5;1;36m            [0m
ECHO             [5;1;36m                              [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m                                                    [0m
ECHO             [5;1;36m[0;30m
ECHO ---------------------------------->>%wmpath%\WMLOG.LOG
ECHO     ***INSTALLING RESOURCES***>>%wmpath%\WMLOG.LOG
ECHO ---------------------------------->>%wmpath%\WMLOG.LOG
%wmpath%\TOOL\BARF %BLOOD_RFF% -a @%wmpath%\RESRFF.rfs>>%wmpath%\WMLOG.LOG
CLS
IF NOT EXIST %wmpath%\SNDRFF.rfs goto play
TYPE %wmpath%\SEMI.SYM>>%wmpath%\SNDRFF.rfs
CLS
ECHO.
ECHO.
ECHO             [5;1;37mĿ[0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                Ŀ              [0m
ECHO             [5;1;37m             ĳ     [5;1;36mNOW SOUNDS[5;1;37m                [0m
ECHO             [5;1;37m                              [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m                                                    [0m
ECHO             [5;1;37m[0;30m
ECHO ---------------------------------->>%wmpath%\WMLOG.LOG
ECHO       ***INSTALLING SOUNDS***>>%wmpath%\WMLOG.LOG
ECHO ---------------------------------->>%wmpath%\WMLOG.LOG
%wmpath%\TOOL\BARF %SOUNDS_RFF% -a @%wmpath%\SNDRFF.rfs>>%wmpath%\WMLOG.LOG
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.

:play
CLS
ECHO [0m
IF %skip_play_screen% == 1 goto play_user
IF %skip_play_screen% == 2 goto play_bat_file
IF %skip_play_screen% == 3 goto multiplayer_screen
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO           Ŀ
ECHO              [7;41m   [1;33mWEAPONS MOD #3  FOR BLOOD V1.10 - 1.21   [7;41m[0m    
ECHO           
IF NOT %BLOOD_RFF% == BLOOD.RFF goto reminder
IF NOT %SOUNDS_RFF% == SOUNDS.RFF goto reminder
IF %BLOOD_RFF% == BLOOD.RFF goto skip_reminder
IF %SOUNDS_RFF% == SOUNDS.RFF goto skip_reminder
:reminder
ECHO.
ECHO           [0;31mREMINDER: [0;35mDIFFERENT RFF ARCHIVE(S) IS CURRENTLY SET![0m
ECHO           [1;36mRFF: [1;37m%BLOOD_RFF%        [1;32mSND: [1;37m%SOUNDS_RFF%[0m
ECHO.
:skip_reminder
ECHO.
ECHO           [1;33m[1][0m BLOOD                               [1;33m[M][0m MULTIPLAYER GAME
ECHO           [1;33m[2][0m CRYPTIC PASSAGE
ECHO.
ECHO           [1;33m[3][0m RUN BLOOD WITH DEFINED PARAMS ([1;35m%params%[0m)
ECHO           [1;33m[4][0m RUN EXTERNAL FILE ([1;34m%bat_file%[0m)
ECHO.
ECHO.
IF %skip_main_screen% == 1 goto disp_back_as_main
ECHO           [1;33m[Q][0m RETURN BACK          [1;33m[W][0m COMMAND PROMT          [1;33m[E][0m EXIT
goto play_screen_footer
:disp_back_as_main
ECHO           [1;33m[Q][0m SELECT WEAPONS        [1;33m[W][0m COMMAND PROMT         [1;33m[E][0m EXIT
:play_screen_footer
ECHO. 
ECHO           [1;37m[0m[1;37m[0m
ECHO                               [1;37mSELECT GAME TO PLAY[0m 
ECHO                             
ECHO.
ECHO.
ECHO.
CHOICE /C:123qwe4m /N ""
IF ERRORLEVEL 8 GOTO multiplayer_screen
IF ERRORLEVEL 7 GOTO play_bat_file
IF ERRORLEVEL 6 GOTO exit_clean
IF ERRORLEVEL 5 GOTO command_line
IF ERRORLEVEL 4 GOTO return_back_clean
IF ERRORLEVEL 3 GOTO play_user
IF ERRORLEVEL 2 GOTO play_crypt
IF ERRORLEVEL 1 GOTO play_blood


:multiplayer_screen
CLS
IF NOT EXIST Z:\IPXNET.COM goto no_mp
IF NOT EXIST COMMIT.EXE goto no_mp
ECHO  Ŀ
ECHO ͵ [7;41m   [1;33mMULTIPLAYER[7;41m   [0m 
ECHO  
ECHO.
ECHO  ͻ
ECHO   [1;31mATTENTION![0m                                              
ECHO   [1;37mALL PLAYERS SHOULD HAVE [0;36mSAME WEAPONS[1;37m INSTALLED IN ORDER[0m 
ECHO   [1;37mTO NOT GET DESYNC IN GAME.[0m                              
ECHO  ͼ
ECHO.
ECHO.
ECHO   [1;33m[1][0m CREATE NEW GAME         Ŀ
ECHO   [1;33m[2][0m JOIN EXISTING GAME       [1;30mWILL OPEN BLOOD'S SETUP TO[0m 
ECHO                                [1;30mSET NUMBER OF PLAYERS AND[0m 
ECHO                                [1;30mVARIOUS NETWORK GAME[0m                                    
ECHO                                [1;30mOPTIONS.[0m                                     
ECHO                                    
ECHO                                             
ECHO                                 
ECHO                             
ECHO                        
ECHO                        
ECHO    
IF NOT EXIST %wmpath%\ANGS.NET ECHO  [1;33m[Q][0m RETURN BACK      [1;33m[A][0m ADVANCED GAME SETUP       [1;33m[E][0m EXIT
IF     EXIST %wmpath%\ANGS.NET ECHO  [1;33m[Q][0m RETURN BACK     [5;32m[0m[1;33m[A][0m ADVANCED GAME SETUP       [1;33m[E][0m EXIT

CHOICE /C:12qae /N ""
IF ERRORLEVEL 5 GOTO exit_clean
IF ERRORLEVEL 4 GOTO multiplayer_advanced
IF ERRORLEVEL 3 GOTO mp_quit
IF ERRORLEVEL 2 GOTO multiplayer_join_game_ask_ip
IF ERRORLEVEL 1 GOTO multiplayer_start_server

:multiplayer_advanced
IF EXIST %wmpath%\ANGS.NET goto mp_adv_unmark
IF NOT EXIST %wmpath%\ANGS.NET goto mp_adv_mark
:mp_adv_unmark
DEL %wmpath%\ANGS.NET
goto multiplayer_screen
:mp_adv_mark
ECHO>%wmpath%\ANGS.NET
goto multiplayer_screen

:multiplayer_start_server
IPXNET STARTSERVER
IF EXIST %wmpath%\ANGS.NET goto multiplayer_run_setup
COMMIT
IPXNET STOPSERVER
goto multiplayer_screen

:multiplayer_join_game_ask_ip
CLS
ECHO Ŀ
ECHO  TO CONNECT TO HOST, YOU MUST KNOW IT'S IP ADRESS.   
ECHO  EXAMPLE: [1;32m123.11.12.13[0m                               
ECHO 
ECHO [1;37m
%wmpath%\TOOL\STRINGS ip=ASK ENTER IP ADRESS AND PRESS ENTER: [1;33m
CLS
ECHO CONNECTING TO: [1;33m%ip%[0m
IPXNET CONNECT %ip%
IF EXIST %wmpath%\ANGS.NET goto multiplayer_run_setup
COMMIT
IPXNET DISCONNECT
goto multiplayer_screen

:multiplayer_run_setup
CLS
SETUP
IPXNET DISCONNECT
IPXNET STOPSERVER
goto multiplayer_screen

:mp_quit
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play

:play_blood
::-----------
CLS
IF %bmouse% == 1 goto play_blood_bmouse
BLOOD %rff_param% %snd_param%>>%wmpath%\WMLOG.LOG
goto play
::-----------

::-----------
:play_blood_bmouse
CLS
BMOUSE.EXE LAUNCH BLOOD.EXE %rff_param% %snd_param%>>%wmpath%\WMLOG.LOG
goto play
::-----------

:play_crypt
::-----------
CLS
IF %bmouse% == 1 goto play_crypt_bmouse
CRYPTIC %rff_param% %snd_param%>>%wmpath%\WMLOG.LOG
goto play
::-----------

:play_crypt_bmouse
::-----------
CLS
BMOUSE.EXE LAUNCH CRYPTIC.EXE %rff_param% %snd_param%>>%wmpath%\WMLOG.LOG
goto play
::-----------

:play_user
::-----------
CLS
IF %params% == none SET params=
IF %bmouse% == 1 goto play_user_bmouse
BLOOD %params% %rff_param% %snd_param%>>%wmpath%\WMLOG.LOG
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play
::-----------

:play_user_bmouse
::-----------
CLS
BMOUSE.EXE LAUNCH %BLOOD_EXE% %params% %rff_param% %snd_param%>>%wmpath%\WMLOG.LOG
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play
::-----------

:play_bat_file
::-----------
CLS
IF %bat_file% == none goto play_blood
IF NOT EXIST %bat_file% goto no_bat_file
SET incmd=1
CALL %bat_file%>>%wmpath%\WMLOG.LOG
SET incmd=0
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play

:no_bat_file
ECHO [0;31mNO EXTERNAL FILE "%bat_file%" FOUNDED.[0m
pause
IF NOT %skip_play_screen% == 0 goto return_back_clean
goto play
::-----------

:command_line
CLS
SET incmd=1
%COMSPEC%
SET incmd=0
goto play

:preset_select_action
CLS
ECHO  Ŀ
ECHO ͵ [7;41m [1;33mPRESETS MANAGER [7;41m[0m 
ECHO  
ECHO.
ECHO  [1;33m[1][0m LOAD PRESET    
ECHO  [1;33m[2][0m SAVE PRESET
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO    
ECHO  [1;33m[Q][0m RETURN BACK    [1;33m[C][0m [1;31mCLEAR ALL PRESET SLOTS[0m
CHOICE /C:12qc /N ""
IF ERRORLEVEL 4 GOTO preset_clear_all
IF ERRORLEVEL 3 GOTO preset_quit
IF ERRORLEVEL 2 GOTO preset_save
IF ERRORLEVEL 1 GOTO preset_load
goto screen


:preset_select_slot
CLS
ECHO  Ŀ
IF %preset_slot_state% == load ECHO ͵ [7;41m   [1;33mLOAD PRESET   [7;41m[0m 
IF %preset_slot_state% == save ECHO ͵ [7;41m   [1;33mSAVE PRESET   [7;41m[0m 
ECHO  
ECHO.
IF %preset_slot_state% == load ECHO  [1;33m[1] [0;32mLOAD FROM SLOT 01[0m
IF %preset_slot_state% == save ECHO  [1;33m[1] [0;32mSAVE TO SLOT 01[0m

IF %preset_slot_state% == load ECHO  [1;33m[2] [0;36mLOAD FROM SLOT 02[0m
IF %preset_slot_state% == save ECHO  [1;33m[2] [0;36mSAVE TO SLOT 02[0m

IF %preset_slot_state% == load ECHO  [1;33m[3] [0;35mLOAD FROM SLOT 03[0m
IF %preset_slot_state% == save ECHO  [1;33m[3] [0;35mSAVE TO SLOT 03[0m
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO  
ECHO  [1;33m[Q][0m RETURN BACK
CHOICE /C:123q /N ""
IF ERRORLEVEL 4 GOTO preset_select_action
IF ERRORLEVEL 3 GOTO preset_slot3
IF ERRORLEVEL 2 GOTO preset_slot2
IF ERRORLEVEL 1 GOTO preset_slot1
goto screen


:preset_slot1
IF %preset_slot_state% == load goto preset_slot1_load
IF %preset_slot_state% == save goto preset_slot1_save
goto preset_select_slot

:preset_slot2
IF %preset_slot_state% == load goto preset_slot2_load
IF %preset_slot_state% == save goto preset_slot2_save
goto preset_select_slot

:preset_slot3
IF %preset_slot_state% == load goto preset_slot3_load
IF %preset_slot_state% == save goto preset_slot3_save
goto preset_select_slot



:preset_slot1_load
CLS
IF NOT EXIST %wmpath%\PRST\SET001 goto preset_no_slot
del %wmpath%\PRST\CURST\*.FLG>nul
copy %wmpath%\PRST\SET001\*.FLG %wmpath%\PRST\CURST>nul
goto screen

:preset_slot2_load
CLS
IF NOT EXIST %wmpath%\PRST\SET002 goto preset_no_slot
del %wmpath%\PRST\CURST\*.FLG>nul
copy %wmpath%\PRST\SET002\*.FLG %wmpath%\PRST\CURST>nul
goto screen

:preset_slot3_load
CLS
IF NOT EXIST %wmpath%\PRST\SET003 goto preset_no_slot
del %wmpath%\PRST\CURST\*.FLG>nul
copy %wmpath%\PRST\SET003\*.FLG %wmpath%\PRST\CURST>nul
goto screen




:preset_slot1_save
CLS
IF NOT EXIST %wmpath%\PRST\SET001 mkdir %wmpath%\PRST\SET001
del %wmpath%\PRST\SET001\*.FLG>nul
copy %wmpath%\PRST\CURST %wmpath%\PRST\SET001>nul
goto preset_slot_saved

:preset_slot2_save
CLS
IF NOT EXIST %wmpath%\PRST\SET002 mkdir %wmpath%\PRST\SET002
del %wmpath%\PRST\SET002\*.FLG>nul
copy %wmpath%\PRST\CURST %wmpath%\PRST\SET002>nul
goto preset_slot_saved

:preset_slot3_save
CLS
IF NOT EXIST %wmpath%\PRST\SET003 mkdir %wmpath%\PRST\SET003
del %wmpath%\PRST\SET003\*.FLG>nul
copy %wmpath%\PRST\CURST %wmpath%\PRST\SET003>nul
goto preset_slot_saved

:preset_clear_all
IF EXIST %wmpath%\PRST\SET001  del %wmpath%\PRST\SET001\*.FLG>nul
IF EXIST %wmpath%\PRST\SET002  del %wmpath%\PRST\SET002\*.FLG>nul
IF EXIST %wmpath%\PRST\SET003  del %wmpath%\PRST\SET003\*.FLG>nul
goto preset_slots_cleared

:preset_slot_saved
CLS
ECHO [1;32mWEAPON SELECTION WAS SUCCESFULLY SAVED TO SELECTED SLOT.
pause
ECHO [0m
goto screen

:preset_no_slot
CLS
ECHO [1;31mSELECTED PRESET SLOT DOES NOT EXIST.
pause
ECHO [0m
goto preset_select_slot

:preset_slots_cleared
CLS
ECHO [1;32mALL PRESET SLOTS IS CLEARED.
pause
ECHO [0m
goto preset_select_action

:preset_load
SET preset_slot_state=load
goto preset_select_slot

:preset_save
SET preset_slot_state=save
goto preset_select_slot

:preset_quit
SET preset_slot_state=
goto screen

:screen_info
CLS
ECHO  Ŀ
IF %info% == INFO.TXT ECHO ͵ [7;41m   [1;33mINFORMATION   [7;41m[0m 
IF %info% == CREDITS.TXT ECHO ͵ [7;41m     [1;33mCREDITS     [7;41m[0m 
IF %info% == LEGEND.TXT ECHO ͵ [7;41m   [1;33mDSCA LEGEND   [7;41m[0m 
ECHO  
TYPE %wmpath%\%info%
ECHO.
ECHO  [0m
ECHO  [1;33m[1][0m INFORMATION    [1;33m[2][0m SHOW DSCA LEGEND    [1;33m[3][0m SHOW CREDITS
ECHO.
CHOICE /C:q123/N " [1;33m[Q][0m RETURN BACK"

IF ERRORLEVEL 4 GOTO info_show_credits
IF ERRORLEVEL 3 GOTO info_show_legend
IF ERRORLEVEL 2 GOTO info_show_basic
IF ERRORLEVEL 1 GOTO screen
goto sreen

:info_show_credits
SET info=CREDITS.TXT
goto screen_info

:info_show_legend
SET info=LEGEND.TXT
goto screen_info

:info_show_basic
SET info=INFO.TXT
goto screen_info


:return_back_clean
IF %pernament_install% == 1 goto screen
ECHO.>>%wmpath%\WMLOG.LOG
ECHO RETURNING BACK AFTER GAME SESSION>>%wmpath%\WMLOG.LOG
ECHO.>>%wmpath%\WMLOG.LOG
DEL %BLOOD_EXE%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
DEL %BLOOD_RFF%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
IF %BLOOD_RFF% == %SOUNDS_RFF% goto screen
DEL %SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
goto screen

:exit_clean
IF %pernament_install% == 1 goto done
ECHO.>>%wmpath%\WMLOG.LOG
ECHO EXITING>>%wmpath%\WMLOG.LOG
ECHO.>>%wmpath%\WMLOG.LOG
DEL %BLOOD_EXE%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%BLOOD_EXE%>>%wmpath%\WMLOG.LOG
DEL %BLOOD_RFF%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%BLOOD_RFF%>>%wmpath%\WMLOG.LOG
IF %BLOOD_RFF% == %SOUNDS_RFF% goto done
DEL %SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
COPY %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
DEL %wmpath%\TEMP\%SOUNDS_RFF%>>%wmpath%\WMLOG.LOG
goto done

:t23clean
DEL TILES023.ART
COPY %wmpath%\TEMP\TILES023.ART
DEL %wmpath%\TEMP\TILES023.ART

:done
IF %pernament_install% == 1 goto cls_end
IF EXIST %wmpath%\TEMP\TILES023.ART goto t23clean
CLS
ECHO  Ŀ 
ECHO   Thanks for playing, visit our sites:  
ECHO                                         
ECHO   http://cruo.bloodgame.ru              
ECHO   http://terrordrome-thegame.com        
ECHO   http://baitd.bloodgame.ru/bme.htm     
ECHO  
ECHO     Installer based on BME/ILMHB script
ECHO          Weapons Mod #3, sep 2017[0m
ECHO.
goto end

:no_blood_rffs
CLS
ECHO.
IF NOT %BLOOD_RFF% == %SOUNDS_RFF% goto two_rff
IF %BLOOD_RFF% == %SOUNDS_RFF% goto single_rff

:no_mp
ECHO [1;31mĿ
ECHO  NO IPXNET UTILITY OR COMMIT DEVICE DRIVER FOUNDED.            
ECHO  MAKE SURE IPX IS ENABLED IN DOSBOX CONFIG FILE.               
ECHO  MULTIPLAYER FUNCTIONAL IS UNAVAILABLE.                        
ECHO [0m
pause
goto return_back_clean

:two_rff
ECHO [1;31mĿ
ECHO  SEEMS THERE ARE NO %BLOOD_RFF% AND/OR %SOUNDS_RFF%                
ECHO  THOSE FILES ARE REQUIRED TO PLAY BLOOD.                       
ECHO  INSTALL %BLOOD_RFF% AND/OR %SOUNDS_RFF% TO BLOOD'S DIRECTORY.     
ECHO [0m
goto end

:single_rff
ECHO [1;31mĿ
ECHO  SEEMS THERE ARE NO %BLOOD_RFF%                     
ECHO  THIS FILE ARE REQUIRED TO PLAY BLOOD.              
ECHO  INSTALL %BLOOD_RFF% TO BLOOD'S DIRECTORY.          
ECHO [0m
ECHO.
goto end

:no_blood_exe
CLS
ECHO.
ECHO [1;31mĿ
ECHO  NO BLOOD FOUNDED IN CURRENT DIRECTORY!              
ECHO  WEAPON MOD MUST BE PLACED IN BLOOD' ROOT DIRECTORY. 
ECHO [0m
ECHO.
goto end

:wm_launched
CLS
ECHO [1;31mĿ
ECHO   WEAPON MOD IS ALREADY LAUNCHED. 
ECHO [0m
goto cmd_end

:no_env_space
CLS
ECHO NOT ENOUGH SPACE FOR VARIABLES.
ECHO RUN WEAPONS MOD UNDER DOSBOX COMMAND PROMT.
pause


:cls_end
CLS

:end
SET pernament_istall=
SET envtest=
SET info=
SET wmpath=
SET bmouse=
SET params=
SET repair=
SET BLOOD_RFF=
SET SOUNDS_RFF=
SET BLOOD_EXE=
SET rff_param=
SET snd_param=
SET skip_play_screen=
SET skip_main_screen=
SET bat_file=

:cmd_end